<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

require_once APPPATH.'libraries/xml_document.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class CCD extends XML_document{
	protected $xpath_namespaces = array('x' => 'urn:hl7-org:v3');

	protected $values_to_parse = array( 'patient_icn' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:id[@root="2.16.840.1.113883.4.349"]',
															   'attribute' => 'extension',
															   'single_value' => true,
															   'default_value' => '&ndash;', ),
										'title' => array( 'xpath_query' => 'x:code[@codeSystem="2.16.840.1.113883.6.1"]', 
														  'attribute' => 'displayName',
														  'single_value' => true,
														  'default_value' => 'Clinical Document'),
										'given_names' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:patient/x:name[@use="L"]/x:given'),
										'family_name' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:patient/x:name[@use="L"]/x:family',
															   'single_value' => true),
										'organization' => array('xpath_query' => 'x:author/x:assignedAuthor/x:representedOrganization/x:name', 'default_value' => '&ndash;', 'single_value' => true),
										'date_of_birth' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:patient/x:birthTime[@value]',  
																  'attribute' => 'value', 
																  'single_value' => true)
										
										
										);
										

	var $schema;
	var $patient;
	var $org;
	
	function date_of_birth(){
		if(empty($this->raw_value('date_of_birth')) || strlen($this->raw_value('date_of_birth')) == 8) return 'Unknown';
		return $this->human_readable_date($this->raw_value('date_of_birth'));
	}
	
	/** 
	* How we'll describe this document throughout webmail
	*/
	function description(){
		$patient_name = $this->patient_name();
		$description = $this->title();
		if(!empty($patient_name)) $description .= ' for '.$patient_name;
		if(!empty($this->raw_value('organization'))){
			$description .= ' from '.$this->organization;
			$description = strip_from_beginning($this->organization, $description); //Title sometimes starts with the organization - we don't need the redundancy
		}
		
		return $description;
	}

	function title(){
		if(!array_key_exists('title', $this->_values)){
			$this->_values['title'] = $this->raw_value('title');
			if(empty($this->raw_value('title'))) $this->_values['title'] = $this->value_for_tag('x:title');
			if(empty($this->raw_value('title'))) $this->_values['title'] = element('default_value', $this->values_to_parse['title'], 'Clinical Document');
		}
		return $this->_values['title'];
	}
	
	function patient_icn(){
		if(!array_key_exists('patient_icn', $this->_values)){
			$this->_values['patient_icn'] = $this->raw_value('patient_icn');
			if(!empty($this->raw_value('patient_icn')) && string_contains('^', $this->raw_value('patient_icn'))) 
				$this->_values['patient_icn'] = substr($this->raw_value('patient_icn'), 0, strpos($this->raw_value('patient_icn'), '^'));
		}
		return $this->_values['patient_icn'];
	}
	
	function patient_name($default_value = NULL){
		$display_name = implode_nonempty(' ', array(implode_nonempty(' ', $this->given_names), $this->family_name));	
		if(empty($display_name) && !is_null($default_value)) return $default_value;
		return $display_name;
	}

	public static function string_matches_schema($xml_string){
		if(empty($xml_string) || !get_instance()->is->xml_string($xml_string)) return false;
	
		$xml = new DOMDocument; 
		$xml->loadXml($xml_string);
		
		$template_ids = $xml->getElementsByTagName('templateId');
		//loop through template ids and find which oids are present
		foreach($template_ids as $id) {
			switch($id->getAttribute('root')) {
				case '2.16.840.1.113883.3.88.11.32.1':
					return TRUE;
					break;
				case '2.16.840.1.113883.10.20.22.1.2':
					return TRUE;
					break;
				case '2.16.840.1.113883.10.20.22.1.2.2':
					return TRUE;
					break;
				default:
					break;
			}
		}
		return FALSE;
	}
	
	protected function human_readable_date($timestamp){
		if(empty($timestamp) || !is_numeric($timestamp) || strlen($timestamp) < 8) return false; //we don't know what to do with it if we don't have YYYYMMDD
		
		//MVI doesn't use unix timestamps - they return dates as YYYYMMDD or YYYYMMDDHHMMSSS
		$year = substr($timestamp, 0, 4);
		$month = substr($timestamp, 4, 2);
		$day = substr($timestamp, 6, 2);
		
		return $month.'/'.$day.'/'.$year;
	}	
	
}
?>